'use client'

import Link from 'next/link'
import { useState, useEffect } from 'react'

export default function CartIcon() {
  const [cartCount, setCartCount] = useState(0)

  useEffect(() => {
    if (typeof window !== 'undefined') {
      const updateCartCount = () => {
        const cart = JSON.parse(localStorage.getItem('cart') || '[]')
        setCartCount(cart.length)
      }

      updateCartCount()
      // Listen for storage changes (when cart is updated on other tabs/pages)
      window.addEventListener('storage', updateCartCount)
      // Custom event for same-tab updates
      window.addEventListener('cartUpdated', updateCartCount)

      return () => {
        window.removeEventListener('storage', updateCartCount)
        window.removeEventListener('cartUpdated', updateCartCount)
      }
    }
  }, [])

  return (
    <Link href="/cart" className="relative inline-block">
      <svg
        xmlns="http://www.w3.org/2000/svg"
        className="h-6 w-6 text-dark-grey"
        fill="none"
        viewBox="0 0 24 24"
        stroke="currentColor"
        strokeWidth={2}
      >
        <path
          strokeLinecap="round"
          strokeLinejoin="round"
          d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"
        />
      </svg>
      {cartCount > 0 && (
        <span className="absolute -top-2 -right-2 bg-red-500 text-white text-xs font-bold rounded-full h-5 w-5 flex items-center justify-center">
          {cartCount}
        </span>
      )}
    </Link>
  )
}

